/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.networking.ChestLootPayload;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.server.SimpleLootPoolBuilder;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ChestLootTableSender
implements LootSender<SimpleLootPoolBuilder> {
    private final String idToSend;
    final List<SimpleLootPoolBuilder> builderList = new LinkedList<SimpleLootPoolBuilder>();
    HashMap<ItemStack, Float> floatMap = new HashMap();

    public ChestLootTableSender(ResourceLocation id) {
        this.idToSend = LootSender.getIdToSend(id);
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            builder.builtMap.forEach((item, weight) -> {
                if (this.floatMap.containsKey(item)) {
                    float oldWeight = this.floatMap.getOrDefault(item, Float.valueOf(0.0f)).floatValue();
                    this.floatMap.put((ItemStack)item, Float.valueOf(oldWeight + weight.floatValue()));
                } else {
                    this.floatMap.put((ItemStack)item, (Float)weight);
                }
            });
        });
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void send(ServerPlayer player) {
        if (!ConfigApi.INSTANCE.network().canSend(ChestLootPayload.TYPE.id(), (Player)player)) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeUtf(this.idToSend);
        buf.writeShort(this.floatMap.size());
        this.floatMap.forEach((item, floatWeight) -> {
            this.writeItemStack(buf, (ItemStack)item, (Level)player.serverLevel());
            buf.writeFloat(floatWeight.floatValue());
        });
        ConfigApi.INSTANCE.network().send((CustomPacketPayload)new ChestLootPayload(buf), (Player)player);
    }

    @Override
    public void addBuilder(SimpleLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<SimpleLootPoolBuilder> getBuilders() {
        return this.builderList;
    }
}

